/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.application.action;

import java.util.UUID;
import org.ametiste.routine.application.service.execution.TaskExecutionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskTimeoutAction {
    private TaskExecutionService taskExecutionService;
    private long defaultTimeout;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public TaskTimeoutAction(TaskExecutionService taskExecutionService, long defaultTimeout) {
        this.taskExecutionService = taskExecutionService;
        this.defaultTimeout = defaultTimeout;
    }

    public void executeAction() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Trying to execute timeouts.");
        }
        Iterable timedOutTasks = null;
        timedOutTasks.forEach(taskId -> {
            block3: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Exectuting timeout for : " + taskId);
                }
                try {
                    this.taskExecutionService.completeTask((UUID)taskId, String.format("Timedout for %s minutes.", this.defaultTimeout));
                }
                catch (Exception e) {
                    if (!this.logger.isDebugEnabled()) break block3;
                    this.logger.debug("Exception during task timeout execution : " + taskId, (Throwable)e);
                }
            }
        });
    }
}

