/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.application.action;

import java.util.List;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.domain.task.TaskRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupCleanAction
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private TaskRepository taskRepository;

    public StartupCleanAction(TaskRepository taskRepository) {
        this.taskRepository = taskRepository;
    }

    @Override
    public void run() {
        List<Task> tasks;
        while ((tasks = this.taskRepository.findTasksByState(Task.State.activeStatesList, 100)).size() != 0) {
            this.logger.warn("Active during startup tasks will be terminated, tasks count is: {} ", (Object)tasks.size());
            this.logger.debug("Tasks ids: {}", tasks);
            tasks.forEach(task -> {
                task.terminate("Active during startup, terminated by StartupCleanAction.");
                this.taskRepository.saveTask((Task)task);
            });
        }
    }
}

