/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.interfaces.web.core.protocol;

import java.util.HashMap;
import java.util.Map;
import org.ametiste.laplatform.sdk.protocol.Protocol;
import org.ametiste.laplatform.sdk.protocol.ProtocolFactory;
import org.ametiste.routine.infrastructure.laplatform.ProtocolStats;

public class ProtocolData {
    private final String name;
    private final Class<? extends Protocol> type;
    private final ProtocolFactory<? extends Protocol> factory;
    private final Map<String, String> operationsMapping;
    private final boolean isProduceEvents;
    private final ProtocolStats protocolStats;

    public ProtocolData(String name, Class<? extends Protocol> type, ProtocolFactory<? extends Protocol> factory, Map<String, String> operationsMapping, boolean isProduceEvents, ProtocolStats protocolStats) {
        this.name = name;
        this.type = type;
        this.factory = factory;
        this.operationsMapping = operationsMapping;
        this.isProduceEvents = isProduceEvents;
        this.protocolStats = protocolStats;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type.getName();
    }

    public String getFactory() {
        return this.factory.getClass().getName();
    }

    public Map<String, String> getOperationsMapping() {
        return this.operationsMapping;
    }

    public boolean isProduceEvents() {
        return this.isProduceEvents;
    }

    public Map<String, Object> getProtocolStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("total-created", this.protocolStats.createdCount());
        stats.put("current-runing", this.protocolStats.currentCount());
        stats.put("period", this.protocolStats.period().toString());
        stats.put("renewed-at", this.protocolStats.renewAt().toString());
        stats.put("total-for-period", this.protocolStats.createdForPeriod());
        return stats;
    }
}

