/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.dsl.configuration.protocol;

import org.ametiste.laplatform.sdk.protocol.GatewayContext;
import org.ametiste.laplatform.sdk.protocol.Protocol;
import org.ametiste.laplatform.sdk.protocol.ProtocolFactory;
import org.springframework.context.ApplicationContext;

class DynamicProtocolFactory<T extends Protocol>
implements ProtocolFactory<T> {
    private final Class<T> protocolType;
    private final ApplicationContext applicationContext;

    public DynamicProtocolFactory(Class<T> protocolType, ApplicationContext applicationContext) {
        this.protocolType = protocolType;
        this.applicationContext = applicationContext;
    }

    public T createProtocol(GatewayContext gatewayContext) {
        try {
            Protocol protocol = (Protocol)this.protocolType.newInstance();
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)protocol);
            return (T)protocol;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<T> protocolType() {
        return this.protocolType;
    }
}

