/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.meta.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.Optional;
import java.util.function.Function;
import org.ametiste.routine.meta.util.MetaMethod;

public class MetaMethodParameter {
    private final MetaMethod metaMethod;
    private final Parameter parameter;

    MetaMethodParameter(MetaMethod metaMethod, Parameter parameter) {
        this.metaMethod = metaMethod;
        this.parameter = parameter;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotation) {
        return this.parameter.isAnnotationPresent(annotation);
    }

    public <T, S extends Annotation> Optional<T> optionalAnnotationValue(Class<S> annotationClass, Function<S, T> valueProducer) {
        if (!this.parameter.isAnnotationPresent(annotationClass)) {
            return Optional.empty();
        }
        return Optional.ofNullable(valueProducer.apply(this.parameter.getDeclaredAnnotation(annotationClass)));
    }

    public <T, S extends Annotation> T annotationValue(Class<S> annotationClass, Function<S, T> valueProducer) {
        return this.optionalAnnotationValue(annotationClass, valueProducer).get();
    }

    public Class<?> type() {
        return this.parameter.getType();
    }
}

