/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.meta.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.ametiste.routine.meta.util.MetaMethodParameter;
import org.ametiste.routine.meta.util.MetaObject;

public class MetaMethod {
    private final MetaObject metaObject;
    private final Method method;

    MetaMethod(MetaObject metaObject, Method method) {
        this.metaObject = metaObject;
        this.method = method;
    }

    MetaMethod(Method method) {
        this(null, method);
    }

    public static final MetaMethod of(MetaObject metaObject, Method method) {
        return new MetaMethod(metaObject, method);
    }

    public static final MetaMethod of(Method method) {
        return new MetaMethod(method);
    }

    public MetaObject ofClass() {
        return this.metaObject;
    }

    public void invoke(Object ... args) {
        if (this.metaObject == null) {
            throw new IllegalStateException("Can't use invoke() method on method with nullable meta-object.");
        }
        try {
            this.method.invoke(this.metaObject.object, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public Stream<MetaMethodParameter> streamOfParameters() {
        return Stream.of(this.method.getParameters()).map(p -> new MetaMethodParameter(this, (Parameter)p));
    }

    public MetaMethod assertParametersCount(int paramsCount) {
        if (this.method.getParameterCount() != paramsCount) {
            throw new IllegalStateException(this.metaObject.object.getClass().getName() + "#" + this.method.getName() + " is expected to have parameters number of: " + paramsCount);
        }
        return this;
    }

    public <T, S extends Annotation> Optional<T> annotationValue(Class<S> annotationClass, Function<S, T> valueProducer) {
        if (!this.method.isAnnotationPresent(annotationClass)) {
            return Optional.empty();
        }
        return Optional.ofNullable(valueProducer.apply(this.method.getDeclaredAnnotation(annotationClass)));
    }

    public MetaMethod assertParameterTypes(Class<?> ... expectedTypes) {
        Class<?>[] actualTypes = this.method.getParameterTypes();
        if (actualTypes.length != expectedTypes.length) {
            throw new IllegalStateException(this.metaObject.object.getClass().getName() + "#" + this.method.getName() + " is expected to have " + expectedTypes.length + " parameters.");
        }
        for (int i = 0; i < expectedTypes.length; ++i) {
            if (actualTypes[i].equals(expectedTypes[i])) continue;
            throw new IllegalStateException(this.metaObject.object.getClass().getName() + "#" + this.method.getName() + " is expected to have parameter #" + i + " of type " + expectedTypes[i] + " but " + actualTypes[i] + " given.");
        }
        return this;
    }

    public String name() {
        return this.method.getName();
    }

    public int paramsCount() {
        return this.method.getParameterAnnotations().length;
    }
}

