/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.dsl.configuration.protocol;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametiste.lang.Pair;
import org.ametiste.lang.StringUtils;
import org.ametiste.laplatform.dsl.LambdaProtocol;
import org.ametiste.laplatform.dsl.ProtocolMeta;
import org.ametiste.laplatform.protocol.gateway.ProtocolGatewayService;
import org.ametiste.laplatform.sdk.protocol.Protocol;
import org.ametiste.routine.dsl.configuration.protocol.DynamicProtocolFactory;
import org.ametiste.routine.meta.util.MetaMethod;
import org.ametiste.routine.meta.util.MetaObject;
import org.ametiste.routine.sdk.mod.ModGateway;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ProtocolDSLConfiguration {
    @Autowired(required=false)
    @LambdaProtocol
    private List<Protocol> lambdaProtocols = Collections.emptyList();
    @Autowired
    private ProtocolGatewayService protocolGatewayService;
    @Autowired
    private ApplicationContext applicationContext;
    private static List<String> excludeMethods = Arrays.asList("wait", "notify");

    @Bean
    public ModGateway modDSLProtocol() {
        List protocolClasses = this.lambdaProtocols.stream().map(Object::getClass).collect(Collectors.toList());
        protocolClasses.stream().map(this::protoGatewayEntry).forEach(arg_0 -> ((ProtocolGatewayService)this.protocolGatewayService).registerProtocol(arg_0));
        return gw -> gw.modInfo("dsl-protocol", "1.1", protocolClasses.stream().collect(Collectors.toMap(s -> s.getName(), s -> "")), Collections.emptyList());
    }

    private ProtocolGatewayService.Entry protoGatewayEntry(Class<? extends Protocol> protocolClass) {
        if (!protocolClass.isAnnotationPresent(LambdaProtocol.class)) {
            throw new IllegalArgumentException("Only @LambdaProtocol classes are allowed.");
        }
        String protocolName = ProtocolDSLConfiguration.resolveProtocolName(protocolClass);
        String protocolGroup = ProtocolDSLConfiguration.resolveProtocolGroup(protocolClass);
        Class<?> protocolType = protocolClass.getInterfaces()[0];
        Map<String, String> operationsMapping = ProtocolDSLConfiguration.resolveOperationNamesMapping(protocolClass);
        return new ProtocolGatewayService.Entry(protocolName, protocolGroup, operationsMapping, protocolType, new DynamicProtocolFactory<Protocol>(protocolClass, this.applicationContext));
    }

    private static String resolveProtocolName(Class<? extends Protocol> protocolClass) {
        String protocolName;
        if (protocolClass.isAnnotationPresent(ProtocolMeta.class)) {
            protocolName = protocolClass.getDeclaredAnnotation(ProtocolMeta.class).shortName();
        } else {
            if (protocolClass.getSimpleName().length() > 16) {
                throw new IllegalArgumentException("Error during protocol " + protocolClass.getName() + " registration" + "Generated protocol shortname " + "length can't be greater than 16. Please use @ProtocolMeta(shortName=) " + "annotation parameter to avoid generated limitations.");
            }
            protocolName = StringUtils.splitCamelCase(protocolClass.getSimpleName());
        }
        return protocolName;
    }

    private static String resolveProtocolGroup(Class<? extends Protocol> protocol) {
        String protocolGroup = protocol.isAnnotationPresent(ProtocolMeta.class) && !protocol.getDeclaredAnnotation(ProtocolMeta.class).group().isEmpty() ? protocol.getDeclaredAnnotation(ProtocolMeta.class).group() : "mods.protocol";
        return protocolGroup;
    }

    private static Map<String, String> resolveOperationNamesMapping(Class<? extends Protocol> protocolClass) {
        Map<String, String> generatedOpsNaming = MetaObject.from(protocolClass).streamOfMethodsWithoutAnnotation(ProtocolMeta.class).filter(m -> ProtocolDSLConfiguration.filterObjectNativeMethods(m.name())).map(m -> Pair.of(m.name(), ProtocolDSLConfiguration.resolveDefaultOperationName(protocolClass, m))).collect(Collectors.toMap(p -> (String)p.first, p -> (String)p.second));
        Map<String, String> definedOpsNames = MetaObject.from(protocolClass).streamOfAnnotatedMethods(ProtocolMeta.class).map(m -> Pair.of(m.name(), m.annotationValue(ProtocolMeta.class, ProtocolMeta::shortName).get())).collect(Collectors.toMap(p -> (String)p.first, p -> (String)p.second));
        HashMap<String, String> operationsMapping = new HashMap<String, String>();
        operationsMapping.putAll(definedOpsNames);
        operationsMapping.putAll(generatedOpsNaming);
        return operationsMapping;
    }

    private static String resolveDefaultOperationName(Class<?> protocolClass, MetaMethod method) {
        if (method.name().length() > 16) {
            throw new IllegalArgumentException("Error during protocol " + protocolClass.getName() + " operation " + method.name() + " registration. " + "Generated operation shortname length can't be greater than 16. Please use @ProtocolMeta(shortName=) " + "annotation parameter to avoid generated limitations.");
        }
        return StringUtils.splitCamelCase(method.name());
    }

    private static boolean filterObjectNativeMethods(String methodName) {
        return !excludeMethods.contains(methodName);
    }
}

