/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.interfaces.web.core.protocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ametiste.laplatform.protocol.gateway.ProtocolGatewayService;
import org.ametiste.laplatform.sdk.protocol.Protocol;
import org.ametiste.laplatform.sdk.protocol.ProtocolFactory;
import org.ametiste.routine.infrastructure.laplatform.LaPlatformStatsService;
import org.ametiste.routine.interfaces.web.core.protocol.CoreProtocolsData;
import org.ametiste.routine.interfaces.web.core.protocol.ProtocolData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/core/protocols"})
public class CoreProtocolController {
    @Autowired
    private ProtocolGatewayService protocolGatewayService;
    @Autowired
    private LaPlatformStatsService laPlatformStatsService;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CoreProtocolsData listProtocols() {
        HashMap<String, List<ProtocolData>> protocolGroups = new HashMap<String, List<ProtocolData>>();
        this.protocolGatewayService.listRegisteredProtocols().forEach(p -> protocolGroups.computeIfAbsent(p.group, k -> new ArrayList()).add(new ProtocolData(p.name, p.factory.protocolType(), (ProtocolFactory<? extends Protocol>)p.factory, p.operationsMapping, p.isProduceEvents, this.laPlatformStatsService.loadProtocolStats(p.type))));
        return new CoreProtocolsData(protocolGroups);
    }
}

