/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.laplatform;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.function.Function;
import org.ametiste.routine.infrastructure.laplatform.Stats;

class PeriodStats {
    private static final PeriodStats EMPTY = new PeriodStats(Duration.ZERO, Stats.empty(), Stats.empty());
    private final Duration duration;
    private final LocalDateTime renewAt;
    private final Stats currentStats;
    private final Stats previousStats;

    PeriodStats(Duration duration, Stats currentStats, Stats previousStats) {
        this(LocalDateTime.now().plus(duration), duration, currentStats, previousStats);
    }

    PeriodStats(LocalDateTime renewAt, Duration duration, Stats currentStats) {
        this(renewAt, duration, currentStats, Stats.empty());
    }

    PeriodStats(LocalDateTime renewAt, Duration duration, Stats currentStats, Stats previousStats) {
        this.duration = duration;
        this.renewAt = renewAt;
        this.currentStats = currentStats;
        this.previousStats = previousStats;
    }

    public static final PeriodStats renewedAfter(Duration duration) {
        return new PeriodStats(duration, Stats.empty(), Stats.empty());
    }

    public static final PeriodStats empty() {
        return EMPTY;
    }

    public Duration duration() {
        return this.duration;
    }

    public LocalDateTime renewAt() {
        return this.renewAt;
    }

    public long createdForPeriod() {
        return this.previousStats.createdCount();
    }

    PeriodStats incCreated() {
        return this.renewOrContinue(Stats::incCreated);
    }

    PeriodStats incCurrent() {
        return this.renewOrContinue(Stats::incCurrent);
    }

    private PeriodStats renewOrContinue(Function<Stats, Stats> statsTransform) {
        PeriodStats result = this.duration.isZero() ? EMPTY : (this.isMustBeRenewed() ? new PeriodStats(this.duration, statsTransform.apply(Stats.empty()), this.currentStats) : new PeriodStats(this.renewAt, this.duration, statsTransform.apply(this.currentStats), this.previousStats));
        return result;
    }

    private boolean isMustBeRenewed() {
        return LocalDateTime.now().isAfter(this.renewAt);
    }
}

