/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.persistency.jpa;

import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.domain.task.notices.Notice;
import org.ametiste.routine.domain.task.reflect.OperationFlare;
import org.ametiste.routine.domain.task.reflect.TaskReflection;
import org.ametiste.routine.infrastructure.persistency.jpa.data.OperationData;
import org.ametiste.routine.infrastructure.persistency.jpa.data.OperationNoticeData;
import org.ametiste.routine.infrastructure.persistency.jpa.data.OperationPropertyData;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskData;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskNoticeData;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskPropertyData;

public class JPATaskReflection
implements TaskReflection {
    private TaskData taskData;

    public JPATaskReflection() {
        this.taskData = new TaskData();
    }

    public JPATaskReflection(TaskData taskData) {
        this.taskData = taskData;
    }

    public void flareTaskId(UUID taskId) {
        this.taskData.setId(taskId);
    }

    public void flareTaskState(Task.State state) {
        this.taskData.setState(state.name());
    }

    public void flareOperation(OperationFlare operationFlare) {
        OperationData operationData = new OperationData();
        operationData.setId(operationFlare.flashId());
        operationData.setLabel(operationFlare.flashLabel());
        operationData.setState(operationFlare.flashState());
        operationFlare.flashNotices().stream().map(n -> {
            OperationNoticeData noticeData = new OperationNoticeData();
            noticeData.setCreationTime(n.creationTime());
            noticeData.setText(n.text());
            return noticeData;
        }).forEach(operationData::addNoticeData);
        operationFlare.flashProperties().entrySet().stream().map(e -> {
            OperationPropertyData propertyData = new OperationPropertyData();
            propertyData.setName((String)e.getKey());
            propertyData.setValue((String)e.getValue());
            return propertyData;
        }).forEach(operationData::addPropertyData);
        this.taskData.addOperationData(operationData);
    }

    public void flareProperty(String name, String value) {
        if (name.equals(Task.SCHEME_PROPERTY_NAME)) {
            this.taskData.setSchemeId(value);
            return;
        }
        if (name.equals(Task.CREATOR_PROPERTY_NAME)) {
            this.taskData.setCreatorId(value);
            return;
        }
        TaskPropertyData taskPropertyData = new TaskPropertyData();
        taskPropertyData.setName(name);
        taskPropertyData.setValue(value);
        this.taskData.addPropertyData(taskPropertyData);
    }

    public void flareTaskTimes(Instant creationTime, Instant executionStartTime, Instant completionTime) {
        this.taskData.setCreationTime(this.mapInstantToDate(creationTime));
        this.taskData.setExecutionStartTime(this.mapInstantToDate(executionStartTime));
        this.taskData.setCompletionTime(this.mapInstantToDate(completionTime));
    }

    public void flareNotice(Notice notice) {
        TaskNoticeData noticeData = new TaskNoticeData();
        noticeData.setText(notice.text());
        noticeData.setCreationTime(notice.creationTime());
        this.taskData.addNoticeData(noticeData);
    }

    public void reflect(TaskReflection reflection) {
        reflection.flareTaskId(this.taskData.getId());
        reflection.flareTaskTimes(this.mapDateToInstant(this.taskData.getCreationTime()), this.mapDateToInstant(this.taskData.getExecutionStartTime()), this.mapDateToInstant(this.taskData.getCompletionTime()));
        reflection.flareTaskState(Task.State.valueOf((String)this.taskData.getState()));
        this.taskData.getOperations().forEach(operation -> {
            List notices = operation.getNotices().stream().map(notice -> new Notice(notice.getText())).collect(Collectors.toList());
            Map<String, String> properties = operation.getProperties().stream().collect(Collectors.toMap(OperationPropertyData::getName, OperationPropertyData::getValue));
            reflection.flareOperation(new OperationFlare(operation.getId(), operation.getLabel(), properties, operation.getState(), notices));
        });
        this.taskData.getNotices().forEach(d -> reflection.flareNotice(new Notice(d.getText())));
        this.taskData.getProperties().forEach(p -> reflection.flareProperty(p.getName(), p.getValue()));
        reflection.flareProperty(Task.SCHEME_PROPERTY_NAME, this.taskData.getSchemeId());
        reflection.flareProperty(Task.CREATOR_PROPERTY_NAME, this.taskData.getCreatorId());
    }

    public TaskData reflectedTaskData() {
        return this.taskData;
    }

    private Date mapInstantToDate(Instant instant) {
        return Optional.ofNullable(instant).map(Date::from).orElse(null);
    }

    private Instant mapDateToInstant(Date date) {
        return Optional.ofNullable(date).map(Date::toInstant).orElse(null);
    }
}

