/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.laplatform;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PreDestroy;
import org.ametiste.laplatform.protocol.tools.ProtocolGatewayInstrumentary;
import org.ametiste.laplatform.protocol.tools.ProtocolGatewayTool;
import org.ametiste.routine.infrastructure.laplatform.LaPlatformStatsService;

class ProtocolGatewayStatsTool
implements ProtocolGatewayTool {
    private final ExecutorService executorService;
    private final LaPlatformStatsService laPlatformStatsService;

    public ProtocolGatewayStatsTool(LaPlatformStatsService laPlatformStatsService) {
        this.laPlatformStatsService = laPlatformStatsService;
        this.executorService = Executors.newFixedThreadPool(1);
    }

    public void apply(ProtocolGatewayInstrumentary gateway) {
        gateway.listenProtocolConnection((protocolType, protocol, name, group) -> this.executorService.execute(() -> {
            this.laPlatformStatsService.incCreated(protocolType, name);
            this.laPlatformStatsService.incCurrent(protocolType, name);
        }));
        gateway.listenProtocolDisconnected((protocolType, protocol, name, group) -> this.executorService.execute(() -> this.laPlatformStatsService.decCurrent(protocolType)));
    }

    @PreDestroy
    public void finish() {
        this.executorService.shutdownNow();
    }
}

