/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.dsl.configuration.task;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametiste.lang.Pair;
import org.ametiste.routine.application.service.issue.TaskIssueService;
import org.ametiste.routine.domain.scheme.SchemeRepository;
import org.ametiste.routine.domain.scheme.TaskBuilder;
import org.ametiste.routine.domain.scheme.TaskScheme;
import org.ametiste.routine.domain.scheme.TaskSchemeException;
import org.ametiste.routine.dsl.annotations.RoutineTask;
import org.ametiste.routine.dsl.annotations.SchemeMapping;
import org.ametiste.routine.dsl.annotations.TaskOperation;
import org.ametiste.routine.dsl.application.DynamicOperationFactory;
import org.ametiste.routine.dsl.application.DynamicOperationScheme;
import org.ametiste.routine.dsl.application.DynamicParamsProtocol;
import org.ametiste.routine.dsl.application.DynamicTaskService;
import org.ametiste.routine.dsl.application.ParameterProvider;
import org.ametiste.routine.dsl.infrastructure.protocol.DirectDynamicParamsProtocol;
import org.ametiste.routine.dsl.infrastructure.protocol.DynamicParamsProtocolRuntime;
import org.ametiste.routine.sdk.mod.ModGateway;
import org.ametiste.routine.sdk.protocol.operation.ParamsProtocol;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.ReflectionUtils;

@Configuration
public class TaskSchemeDSLConfiguration {
    @Autowired(required=false)
    @RoutineTask
    private List<Object> taskControllers = Collections.emptyList();
    @Autowired
    private SchemeRepository schemeRepository;
    @Autowired
    private TaskIssueService taskIssueService;
    @Autowired
    private ConversionService conversionService;
    @Autowired
    private List<ParameterProvider> paramProviders;

    @Bean
    public DynamicParamsProtocolRuntime dynamicParamsProtocolRuntimeFactory() {
        return new DynamicParamsProtocolRuntime();
    }

    @Bean
    public DynamicTaskService dynamicTaskService() {
        return new DynamicTaskService(this.schemeRepository, this.taskIssueService);
    }

    @Bean
    public ModGateway modTaskSchemeDSL() {
        List<TaskScheme> schemes = this.taskControllers.stream().map(Object::getClass).map(this::mapToTaskScheme).collect(Collectors.toList());
        schemes.forEach(arg_0 -> ((SchemeRepository)this.schemeRepository).saveScheme(arg_0));
        return gw -> gw.modInfo("dsl-task-scheme", "1.1", schemes.stream().collect(Collectors.toMap(s -> s.schemeName(), s -> s.getClass().getName())), Collections.emptyList());
    }

    private TaskScheme mapToTaskScheme(Class<?> controllerClass) {
        if (!controllerClass.isAnnotationPresent(RoutineTask.class)) {
            throw new IllegalArgumentException("Only @RoutineTask classes are allowed.");
        }
        final String schemeName = controllerClass.getDeclaredAnnotation(SchemeMapping.class).schemeName();
        final List<DynamicOperationScheme> operations = Stream.of(ReflectionUtils.getAllDeclaredMethods(controllerClass)).filter(m -> m.isAnnotationPresent(TaskOperation.class)).sorted((t, o) -> {
            int second;
            int first = t.getDeclaredAnnotation(TaskOperation.class).order();
            if (first > (second = o.getDeclaredAnnotation(TaskOperation.class).order())) {
                return 1;
            }
            if (first < second) {
                return -1;
            }
            throw new IllegalStateException("Operations order is undefined. Please define unique operations order explicitly.");
        }).map(m -> Pair.of(this.resolveOperationName((Method)m), new DynamicOperationFactory(controllerClass, (Method)m, this.paramProviders))).map(p -> new DynamicOperationScheme((String)p.first(), (DynamicOperationFactory)p.second())).collect(Collectors.toList());
        operations.forEach(arg_0 -> ((SchemeRepository)this.schemeRepository).saveScheme(arg_0));
        return new TaskScheme<DynamicParamsProtocol>(){

            public String schemeName() {
                return schemeName;
            }

            public void setupTask(TaskBuilder<DynamicParamsProtocol> taskBuilder, Consumer<DynamicParamsProtocol> paramsInstaller, String creatorIdenifier) throws TaskSchemeException {
                DirectDynamicParamsProtocol dynamicParamsProtocol = new DirectDynamicParamsProtocol();
                paramsInstaller.accept(dynamicParamsProtocol);
                operations.forEach(op -> taskBuilder.addOperation(op.schemeName(), (ParamsProtocol)dynamicParamsProtocol));
            }
        };
    }

    private String resolveOperationName(Method m) {
        String declaredName = m.getDeclaredAnnotation(TaskOperation.class).schemeName();
        String resolvedOpName = declaredName.isEmpty() ? m.getName() : declaredName;
        return resolvedOpName;
    }
}

