/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.configuration;

import java.util.List;
import org.ametiste.laplatform.protocol.gateway.ProtocolGatewayService;
import org.ametiste.laplatform.sdk.protocol.ProtocolFactory;
import org.ametiste.metrics.MetricsService;
import org.ametiste.routine.application.CoreEventsGateway;
import org.ametiste.routine.application.TaskDomainEvenetsGateway;
import org.ametiste.routine.configuration.AmetisteRoutineCoreProperties;
import org.ametiste.routine.domain.scheme.SchemeRepository;
import org.ametiste.routine.domain.task.TaskRepository;
import org.ametiste.routine.infrastructure.execution.LineExecutionGateway;
import org.ametiste.routine.infrastructure.execution.OperationRuntime;
import org.ametiste.routine.infrastructure.execution.TaskExecutionGateway;
import org.ametiste.routine.infrastructure.execution.local.LocalLineExecutionGateway;
import org.ametiste.routine.infrastructure.execution.local.LocalTaskExecutionController;
import org.ametiste.routine.infrastructure.execution.local.LocalTaskExecutionGateway;
import org.ametiste.routine.infrastructure.execution.local.TaskExecutionController;
import org.ametiste.routine.infrastructure.messaging.JmsTaskExecutionGatewayListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={AmetisteRoutineCoreProperties.class})
public class LocalTaskExecutionGatewayConfiguration {
    @Autowired
    private AmetisteRoutineCoreProperties props;
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    private TaskDomainEvenetsGateway domainEvenetsGateway;
    @Autowired
    private CoreEventsGateway coreEventsGateway;
    @Autowired
    private ProtocolGatewayService protocolGatewayservice;
    @Autowired
    private SchemeRepository schemeRepository;
    @Autowired
    private MetricsService metricsService;
    @Autowired
    private List<OperationRuntime<ProtocolFactory<?>>> runtimeProtocols;

    @Bean
    public LineExecutionGateway localLineExecutionGateway() {
        return new LocalLineExecutionGateway(this.schemeRepository, this.localTaskExecutionController(), this.protocolGatewayservice, this.runtimeProtocols);
    }

    @Bean
    public TaskExecutionController localTaskExecutionController() {
        return new LocalTaskExecutionController(this.taskRepository, this.domainEvenetsGateway, this.coreEventsGateway);
    }

    @Bean
    public TaskExecutionGateway localTaskExecutionGateway() {
        return new LocalTaskExecutionGateway(this.localLineExecutionGateway(), this.props.getInitialExecutionConcurrency(), this.localTaskExecutionController());
    }

    @Bean
    public JmsTaskExecutionGatewayListener jmsTaskExecutionGatewayListener() {
        return new JmsTaskExecutionGatewayListener(this.localTaskExecutionGateway());
    }
}

