/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.persistency.jpa.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.ametiste.routine.infrastructure.persistency.jpa.data.OperationData;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskNoticeData;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskPropertyData;
import org.hibernate.annotations.ForeignKey;
import org.springframework.data.domain.Persistable;

@Entity
@Table(name="ame_routine_task", indexes={@Index(name="task_state_idx", columnList="state", unique=false), @Index(name="task_creator_idx", columnList="creatorId", unique=false), @Index(name="task_scheme_idx", columnList="schemeId", unique=false), @Index(name="task_cr_time_idx", columnList="cr_time", unique=false), @Index(name="task_execs_time_idx", columnList="execs_time", unique=false), @Index(name="task_co_time_idx", columnList="co_time", unique=false)})
public class TaskData
implements Persistable<UUID> {
    private UUID id;
    private String state;
    private List<OperationData> operations = new ArrayList<OperationData>();
    private List<TaskPropertyData> properties = new ArrayList<TaskPropertyData>();
    private List<TaskNoticeData> notices = new ArrayList<TaskNoticeData>();
    private String creatorId;
    private String schemeId;
    private Date creationTime;
    private Date executionStartTime;
    private Date completionTime;

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="task")
    public List<OperationData> getOperations() {
        return this.operations;
    }

    @ElementCollection
    @CollectionTable(name="ame_routine_task_property", joinColumns={@JoinColumn(name="task_id")}, indexes={@Index(name="task_prop_task_id_idx", columnList="task_id", unique=false)})
    @ForeignKey(name="fk_task_prop_task_id")
    public List<TaskPropertyData> getProperties() {
        return this.properties;
    }

    @ElementCollection
    @CollectionTable(name="ame_routine_task_notice", joinColumns={@JoinColumn(name="task_id")}, indexes={@Index(name="task_notice_task_id_idx", columnList="task_id", unique=false)})
    @ForeignKey(name="fk_task_notice_task_id")
    public List<TaskNoticeData> getNotices() {
        return this.notices;
    }

    @Id
    public UUID getId() {
        return this.id;
    }

    @Column(name="co_time")
    public Date getCompletionTime() {
        return this.completionTime;
    }

    @Column(name="execs_time")
    public Date getExecutionStartTime() {
        return this.executionStartTime;
    }

    @Column(name="cr_time")
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Transient
    public boolean isNew() {
        return this.state.equals("NEW");
    }

    public void setNotices(List<TaskNoticeData> notices) {
        this.notices = notices;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(String schemeId) {
        this.schemeId = schemeId;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public void setExecutionStartTime(Date executionStartTime) {
        this.executionStartTime = executionStartTime;
    }

    public void setCompletionTime(Date completionTime) {
        this.completionTime = completionTime;
    }

    public void addNoticeData(TaskNoticeData noticeData) {
        this.notices.add(noticeData);
    }

    public void addPropertyData(TaskPropertyData propertyData) {
        this.properties.add(propertyData);
    }

    public void addOperationData(OperationData operationData) {
        operationData.setTask(this);
        this.operations.add(operationData);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setOperations(List<OperationData> operations) {
        this.operations = operations;
    }

    public void setProperties(List<TaskPropertyData> properties) {
        this.properties = properties;
    }
}

