/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.dsl.infrastructure;

import org.ametiste.laplatform.protocol.tools.ProtocolGatewayInstrumentary;
import org.ametiste.laplatform.protocol.tools.ProtocolGatewayTool;
import org.ametiste.metrics.MetricsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class DynamicProtocolMetricsTool
implements ProtocolGatewayTool {
    private final MetricsService metricsService;

    @Autowired
    public DynamicProtocolMetricsTool(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    public void apply(ProtocolGatewayInstrumentary gateway) {
        gateway.listenInvocationsTiming((c, p, g, o, t) -> {
            this.metricsService.createEvent(g + "." + p + ".overall." + o + ".timing", (int)t);
            this.metricsService.createEvent(g + "." + p + ".clients." + c + "." + o + ".timing", (int)t);
        });
        gateway.listenErrors((c, p, g, o, e) -> {
            this.metricsService.createEvent(g + "." + p + ".overall." + o + ".errors", 1);
            this.metricsService.createEvent(g + "." + p + ".clients." + c + "." + o + ".errors", 1);
        });
    }
}

