/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.meta.scheme;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.ametiste.lang.object.trace.MethodCallEvent;
import org.ametiste.lang.object.trace.MethodCallListener;
import org.ametiste.routine.dsl.annotations.OperationParameter;
import org.ametiste.routine.meta.scheme.TaskSchemeTrace;

class TaskSchemeCallListener
implements MethodCallListener {
    private final String schemeName;
    private final List<Map<String, String>> calls = new ArrayList<Map<String, String>>(4);

    public TaskSchemeCallListener(String schemeName) {
        this.schemeName = schemeName;
    }

    public void methodCalled(MethodCallEvent methodCallEvent) {
        int p = 0;
        HashMap<String, String> callParams = new HashMap<String, String>();
        for (Annotation[] parameterType : methodCallEvent.method().getParameterAnnotations()) {
            if (!(parameterType[0] instanceof OperationParameter)) {
                throw new IllegalStateException("");
            }
            callParams.put(((OperationParameter)parameterType[0]).value(), methodCallEvent.args()[p].toString());
            ++p;
        }
        this.calls.add(callParams);
    }

    public void schemeCall(Consumer<TaskSchemeTrace> schemeCallConsumer) {
        schemeCallConsumer.accept(new TaskSchemeTrace(this.schemeName, this.calls));
    }
}

