/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.messaging;

import java.io.Serializable;
import java.util.UUID;
import org.ametiste.routine.application.TaskDomainEvenetsGateway;
import org.ametiste.routine.domain.task.OperationTerminatedEvent;
import org.ametiste.routine.domain.task.TaskTerminatedEvent;
import org.springframework.jms.core.JmsTemplate;

public class JmsTaskDomainEventsGateway
implements TaskDomainEvenetsGateway {
    private final JmsTemplate jmsTemplate;

    public JmsTaskDomainEventsGateway(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void taskIssued(UUID taskId) {
        this.jmsTemplate.send("task-issued", s -> s.createObjectMessage((Serializable)taskId));
    }

    public void operationTerminated(OperationTerminatedEvent event) {
    }

    public void taskTerminated(TaskTerminatedEvent event) {
        this.jmsTemplate.send("task-terminated", s -> s.createObjectMessage((Serializable)event));
    }
}

