/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.dsl.application;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.ametiste.laplatform.protocol.ProtocolGateway;
import org.ametiste.laplatform.sdk.protocol.Protocol;
import org.ametiste.routine.dsl.annotations.Connect;
import org.ametiste.routine.dsl.annotations.OperationParameter;
import org.ametiste.routine.dsl.application.DynamicOperation;
import org.ametiste.routine.dsl.application.DynamicParamsProtocol;
import org.ametiste.routine.sdk.operation.OperationFeedback;
import org.springframework.util.ReflectionUtils;

public class DynamicOperationFactory {
    private final Method method;
    private final Class<?> controllerClass;

    public DynamicOperationFactory(Class<?> controllerClass, Method method) {
        this.controllerClass = controllerClass;
        this.method = method;
    }

    public DynamicOperation createDynamicOperation(OperationFeedback operationFeedback, ProtocolGateway protocolGateway) {
        Object controllerInstance;
        Object[] params = new Object[this.method.getParameterAnnotations().length];
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        try {
            controllerInstance = this.controllerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        Stream.of(this.controllerClass.getDeclaredFields()).filter(f -> f.isAnnotationPresent(Connect.class)).forEach(f -> {
            Protocol session = protocolGateway.session(f.getType());
            ReflectionUtils.makeAccessible((Field)f);
            ReflectionUtils.setField((Field)f, (Object)controllerInstance, (Object)session);
        });
        int p = 0;
        for (Annotation[] parameterType : this.method.getParameterAnnotations()) {
            if (!(parameterType[0] instanceof OperationParameter)) {
                throw new IllegalStateException("");
            }
            params[p] = ((DynamicParamsProtocol)protocolGateway.session(DynamicParamsProtocol.class)).param(((OperationParameter)parameterType[0]).value());
            ++p;
        }
        return () -> {
            try {
                this.method.invoke(controllerInstance, params);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

