/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.stat.interfaces.metrics;

import org.ametiste.metrics.MetricsService;
import org.ametiste.routine.infrastructure.persistency.jpa.JPATaskDataRepository;
import org.ametiste.routine.stat.CoreStatRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"org.ametiste.routine.metrics.source.info.stored-tasks-count.enabled"}, matchIfMissing=true)
public class TasksCountMetricSource {
    @Autowired(required=false)
    private MetricsService metricsService;
    @Autowired(required=false)
    private JPATaskDataRepository taskDataRepository;
    @Autowired
    private CoreStatRepository coreStatRepository;

    @Scheduled(fixedRate=30000L)
    public void countMetrics() {
        if (this.taskDataRepository == null || this.metricsService == null) {
            return;
        }
        this.metricsService.gauge("core.info.stored-tasks-count", (int)this.taskDataRepository.count());
        this.metricsService.gauge("core.info.terminated-tasks-count", this.coreStatRepository.loadStat("terminated").intValue());
        this.metricsService.gauge("core.info.done-tasks-count", this.coreStatRepository.loadStat("done").intValue());
    }
}

