/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.meta.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ametiste.routine.meta.util.MetaObject;

public class MetaMethod {
    private final MetaObject metaObject;
    private final Method method;

    public MetaMethod(MetaObject metaObject, Method method) {
        this.metaObject = metaObject;
        this.method = method;
    }

    public static final MetaMethod of(MetaObject metaObject, Method method) {
        return new MetaMethod(metaObject, method);
    }

    public MetaObject ofClass() {
        return this.metaObject;
    }

    public void invoke(Object ... args) {
        try {
            this.method.invoke(this.metaObject.object, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public MetaMethod assertParametersCount(int paramsCount) {
        if (this.method.getParameterCount() != paramsCount) {
            throw new IllegalStateException(this.metaObject.object.getClass().getName() + "#" + this.method.getName() + " is expected to have parameters number of: " + paramsCount);
        }
        return this;
    }

    public MetaMethod assertAttributesTypes(Class<?> ... expectedTypes) {
        Class<?>[] actualTypes = this.method.getParameterTypes();
        if (actualTypes.length != expectedTypes.length) {
            throw new IllegalStateException(this.metaObject.object.getClass().getName() + "#" + this.method.getName() + " is expected to have " + expectedTypes.length + " parameters.");
        }
        for (int i = 0; i < expectedTypes.length; ++i) {
            if (actualTypes[i].equals(expectedTypes[i])) continue;
            throw new IllegalStateException(this.metaObject.object.getClass().getName() + "#" + this.method.getName() + " is expected to have parameter #" + i + " of type " + expectedTypes[i] + " but " + actualTypes[i] + " given.");
        }
        return this;
    }
}

