/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.meta.scheme;

import java.util.Collections;
import java.util.function.Consumer;
import org.ametiste.lang.Let;
import org.ametiste.lang.object.trace.CallsTraceScaner;
import org.ametiste.routine.dsl.annotations.RoutineTask;
import org.ametiste.routine.dsl.annotations.SchemeMapping;
import org.ametiste.routine.meta.scheme.TaskSchemeCallListener;
import org.ametiste.routine.meta.scheme.TaskSchemeTrace;

public class TaskMetaScheme<T> {
    private final Class<T> schemeType;
    private final String schemeName;

    public TaskMetaScheme(Class<T> schemeType) {
        if (!schemeType.isAnnotationPresent(SchemeMapping.class) || !schemeType.isAnnotationPresent(RoutineTask.class)) {
            throw new IllegalArgumentException("Only classes marked as @RoutineTask and @SchemeMapping are task scheme classes.");
        }
        this.schemeType = schemeType;
        this.schemeName = schemeType.getDeclaredAnnotation(SchemeMapping.class).schemeName();
    }

    public String schemeName() {
        return this.schemeName;
    }

    public Let<TaskSchemeTrace> trace(Consumer<T> callsProducer) {
        TaskSchemeCallListener schemeCallListener = new TaskSchemeCallListener(this.schemeName);
        CallsTraceScaner traceScaner = new CallsTraceScaner(this.schemeType, Collections.singletonList(schemeCallListener));
        traceScaner.createTrace().recordTrace(callsProducer);
        return schemeCallListener::schemeCall;
    }

    public static final <T> TaskMetaScheme<T> of(Class<T> taskScheme) {
        return new TaskMetaScheme<T>(taskScheme);
    }
}

