/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.mod;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ametiste.routine.domain.ModReportRepository;

public class InMemoryModReportRepository
implements ModReportRepository {
    private final ConcurrentHashMap<String, List<Map<String, String>>> reports = new ConcurrentHashMap();

    public void saveModReport(String modId, Map<String, String> report) {
        List modReports = this.reports.computeIfAbsent(modId, k -> new ArrayList());
        if (modReports.size() == 3) {
            modReports.remove(0);
            modReports.add(report);
        } else {
            modReports.add(report);
        }
    }

    public List<Map<String, String>> loadModReports(String modId) {
        return Collections.unmodifiableList(this.reports.getOrDefault(modId, Collections.emptyList()));
    }

    public List<Map<String, String>> loadModReports() {
        ArrayList<Map<String, String>> allReports = new ArrayList<Map<String, String>>();
        this.reports.values().forEach(allReports::addAll);
        return allReports;
    }
}

