/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.dsl.configuration;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.ametiste.laplatform.protocol.Protocol;
import org.ametiste.laplatform.protocol.gateway.ProtocolGatewayService;
import org.ametiste.routine.dsl.annotations.LambdaProtocol;
import org.ametiste.routine.sdk.mod.ModGateway;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ProtocolDSLConfiguration {
    @Autowired(required=false)
    @LambdaProtocol
    private List<Protocol> lambdaProtocols = Collections.emptyList();
    @Autowired
    private ProtocolGatewayService protocolGatewayService;
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    public ModGateway modDSLProtocol() {
        List protocolClasses = this.lambdaProtocols.stream().map(Object::getClass).collect(Collectors.toList());
        protocolClasses.stream().map(this::protoGatewayEntry).forEach(arg_0 -> ((ProtocolGatewayService)this.protocolGatewayService).registerGatewayFactory(arg_0));
        return gw -> gw.modInfo("dsl-protocol", "1.1", protocolClasses.stream().collect(Collectors.toMap(s -> s.getName(), s -> "")));
    }

    private ProtocolGatewayService.Entry protoGatewayEntry(Class<? extends Protocol> protocolClass) {
        if (!protocolClass.isAnnotationPresent(LambdaProtocol.class)) {
            throw new IllegalArgumentException("Only @LambdaProtocol classes are allowed.");
        }
        return new ProtocolGatewayService.Entry(protocolClass.getInterfaces()[0], c -> {
            try {
                Protocol protocol = (Protocol)protocolClass.newInstance();
                this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)protocol);
                return protocol;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

