/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.dsl.configuration.task.params;

import org.ametiste.dynamics.foundation.elements.AnnotatedRef;
import org.ametiste.dynamics.foundation.elements.AnnotatedRefProcessor;
import org.ametiste.laplatform.protocol.ProtocolGateway;
import org.ametiste.routine.dsl.annotations.ParamValueProvider;
import org.ametiste.routine.dsl.application.DynamicParamsProtocol;
import org.ametiste.routine.dsl.domain.OperationParameterAnnotation;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.stereotype.Component;

@Component
@ParamValueProvider
class OperationParameterProvider
extends AnnotatedRefProcessor<OperationParameterAnnotation, Object, ProtocolGateway> {
    private final ConversionService conversionService;

    @Autowired
    public OperationParameterProvider(ConversionService conversionService) {
        super(OperationParameterAnnotation::new);
        this.conversionService = conversionService;
    }

    @Override
    protected void resolveValue(@NotNull AnnotatedRef<Object> element, @NotNull ProtocolGateway protocolGateway) {
        String paramName = ((OperationParameterAnnotation)element.annotation(this.annotationSpec)).nameOrThrow(() -> new IllegalStateException("Can't resolve paramter name."));
        Object value = ((DynamicParamsProtocol)protocolGateway.session(DynamicParamsProtocol.class)).param(paramName);
        element.provideValue(this.conversionService.convert(value, element.type()));
    }
}

