/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.configuration;

import java.util.List;
import org.ametiste.routine.RoutineCoreSpring;
import org.ametiste.routine.application.CoreEventsGateway;
import org.ametiste.routine.application.TaskDomainEvenetsGateway;
import org.ametiste.routine.application.service.issue.DefaultTaskIssueService;
import org.ametiste.routine.application.service.issue.NamedTaskSchemeService;
import org.ametiste.routine.application.service.issue.TaskIssueService;
import org.ametiste.routine.application.service.removing.DefaultTaskRemovingService;
import org.ametiste.routine.application.service.removing.TaskRemovingService;
import org.ametiste.routine.application.service.termination.DefaultTaskTerminationService;
import org.ametiste.routine.application.service.termination.TaskTerminationService;
import org.ametiste.routine.configuration.AmetisteRoutineCoreProperties;
import org.ametiste.routine.domain.ModReportRepository;
import org.ametiste.routine.domain.ModRepository;
import org.ametiste.routine.domain.scheme.SchemeRepository;
import org.ametiste.routine.domain.task.TaskRepository;
import org.ametiste.routine.domain.task.properties.TaskPropertiesRegistry;
import org.ametiste.routine.domain.task.properties.TaskProperty;
import org.ametiste.routine.infrastructure.messaging.JmsTaskDomainEventsGateway;
import org.ametiste.routine.infrastructure.messaging.SpringCoreEventsGateway;
import org.ametiste.routine.infrastructure.mod.InMemoryModReportRepository;
import org.ametiste.routine.infrastructure.mod.SpringDataModRepository;
import org.ametiste.routine.infrastructure.mod.jpa.JPAModDataRepository;
import org.ametiste.routine.interfaces.web.task.TaskController;
import org.ametiste.routine.sdk.application.service.issue.constraints.IssueConstraint;
import org.ametiste.routine.stat.configuration.CoreStatConfiguration;
import org.ametiste.routine.stat.interfaces.metrics.InfoMetrics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityScan;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jms.core.JmsTemplate;

@Configuration
@ComponentScan(basePackageClasses={TaskController.class, InfoMetrics.class, RoutineCoreSpring.class})
@EntityScan(basePackageClasses={RoutineCoreSpring.class})
@EnableJpaRepositories(basePackageClasses={RoutineCoreSpring.class})
@EnableConfigurationProperties(value={AmetisteRoutineCoreProperties.class})
@Import(value={CoreStatConfiguration.class})
@PropertySource(value={"classpath:/routine.properties"})
public class AmetisteRoutineCoreConfiguration {
    @Autowired
    private TaskRepository taskRepository;
    @Autowired(required=false)
    private List<IssueConstraint> issueConstraints;
    @Autowired
    private TaskPropertiesRegistry taskPropertiesRegistry;
    @Autowired
    private SchemeRepository schemeRepository;
    @Autowired
    private JmsTemplate jmsTemplate;
    @Autowired
    private JPAModDataRepository modDataRepository;
    @Autowired
    private AmetisteRoutineCoreProperties props;
    @Autowired
    private ApplicationEventPublisher springEventPublisher;

    @Bean
    public SpringCoreEventsGateway springCoreEventsGateway() {
        return new SpringCoreEventsGateway(this.springEventPublisher);
    }

    @Bean
    @ConditionalOnMissingBean
    public TaskTerminationService taskExecutionService() {
        return new DefaultTaskTerminationService(this.taskRepository, this.domainEventsGateway(), (CoreEventsGateway)this.springCoreEventsGateway());
    }

    @Bean
    public TaskIssueService taskIssueService() {
        return new DefaultTaskIssueService(this.taskRepository, this.taskPropertiesRegistry, this.schemeRepository, this.domainEventsGateway(), (CoreEventsGateway)this.springCoreEventsGateway(), this.issueConstraints);
    }

    @Bean
    public NamedTaskSchemeService dynamicTaskService() {
        return new NamedTaskSchemeService(this.schemeRepository, this.taskIssueService());
    }

    @Bean
    public TaskRemovingService taskRemovingService() {
        return new DefaultTaskRemovingService(this.taskRepository, (CoreEventsGateway)this.springCoreEventsGateway());
    }

    @Bean
    public ModRepository modDataRepository() {
        return new SpringDataModRepository(this.modDataRepository);
    }

    @Bean
    public ModReportRepository modReportRepository() {
        return new InMemoryModReportRepository();
    }

    @Bean
    @ConditionalOnMissingBean
    public TaskDomainEvenetsGateway domainEventsGateway() {
        return new JmsTaskDomainEventsGateway(this.jmsTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public TaskPropertiesRegistry taskPropertiesRegistry() {
        return new TaskPropertiesRegistry(){

            public TaskProperty createTaskProperty(String kind, String value) {
                return null;
            }
        };
    }
}

