/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.lang;

import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.ametiste.lang.Pair;

public final class Zip {
    private Zip() {
    }

    public static final <A, B> Stream<Pair<A, B>> zip(Stream<A> as, Stream<B> bs) {
        final Iterator i1 = as.iterator();
        final Iterator i2 = bs.iterator();
        Iterable i = () -> new Iterator<Pair<A, B>>(){

            @Override
            public boolean hasNext() {
                return i1.hasNext() && i2.hasNext();
            }

            @Override
            public Pair<A, B> next() {
                return new Pair(i1.next(), i2.next());
            }
        };
        return StreamSupport.stream(i.spliterator(), false);
    }

    public static final <T, U> boolean constraint(List<T> first, List<U> second, BiPredicate<T, U> ... criteria) {
        BiPredicate<Object, Object> predicate = Stream.of(criteria).reduce((t, o) -> true, BiPredicate::and);
        return Zip.zip(first.stream(), second.stream()).allMatch(p -> predicate.test(p.first, p.second));
    }

    public static final <T, U> boolean isIsomorph(List<T> first, List<U> second, BiPredicate<T, U> ... homs) {
        if (first.size() != second.size()) {
            return false;
        }
        if (homs.length == 0) {
            return false;
        }
        BiPredicate<Object, Object> homPredicate = Stream.of(homs).reduce((t, o) -> true, BiPredicate::and);
        Predicate predicateOverFirst = second.stream().map(s -> f -> homPredicate.test(f, s)).reduce(f -> false, Predicate::or);
        return first.stream().filter(predicateOverFirst).count() == (long)first.size();
    }
}

