/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.dynamics.foundation.reflection.structures;

import java.lang.reflect.Field;
import java.util.function.Function;
import org.ametiste.dynamics.SurfaceStructure;
import org.ametiste.dynamics.foundation.elements.AnnotationSpec;
import org.ametiste.dynamics.foundation.reflection.structures.Annotated;
import org.ametiste.dynamics.foundation.reflection.structures.AnnotatedDescriptor;
import org.ametiste.dynamics.foundation.reflection.structures.ClassField;
import org.ametiste.dynamics.foundation.reflection.structures.ObjectInstance;
import org.ametiste.dynamics.foundation.reflection.structures.Reference;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.ReflectionUtils;

@SurfaceStructure
public class ObjectInstanceField<T>
implements Reference<T>,
Annotated {
    private final ClassField classField;
    private final ObjectInstance<?> objectInstance;

    public ObjectInstanceField(@NotNull ClassField classField, @NotNull ObjectInstance<?> objectInstance) {
        this.classField = classField;
        this.objectInstance = objectInstance;
    }

    @Override
    public boolean ofType(@NotNull Class<?> type) {
        return type.isAssignableFrom(this.classField.type());
    }

    @Override
    @NotNull
    public Class<T> type() {
        return this.classField.type();
    }

    @Override
    public void referencesTo(@NotNull T ref) {
        ReflectionUtils.makeAccessible((Field)this.classField.field);
        ReflectionUtils.setField((Field)this.classField.field, this.objectInstance.object, ref);
    }

    @Override
    @NotNull
    public <T extends AnnotationSpec> T annotation(@NotNull Function<AnnotatedDescriptor, T> value) {
        return this.classField.annotation(value);
    }

    @Override
    public boolean hasAnnotations(@NotNull Function<AnnotatedDescriptor, ? extends AnnotationSpec> handler) {
        return this.classField.hasAnnotations(handler);
    }
}

