/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.dynamics.foundation.reflection.structures;

import java.lang.reflect.Parameter;
import java.util.function.Function;
import org.ametiste.dynamics.SurfaceStructure;
import org.ametiste.dynamics.foundation.elements.AnnotationSpec;
import org.ametiste.dynamics.foundation.reflection.structures.Annotated;
import org.ametiste.dynamics.foundation.reflection.structures.AnnotatedDescriptor;
import org.ametiste.dynamics.foundation.reflection.structures.AnnotatedDescriptorDelegate;
import org.ametiste.dynamics.foundation.reflection.structures.ClassMethod;
import org.ametiste.dynamics.foundation.reflection.structures.Reference;
import org.jetbrains.annotations.NotNull;

@SurfaceStructure(superStructure={ClassMethod.class})
public class MethodParameter<T>
implements Reference<T>,
Annotated {
    private final ClassMethod methodStructure;
    private final Parameter parameter;
    private final AnnotatedDescriptorDelegate rawAnnotated;
    private T ref;

    public MethodParameter(@NotNull ClassMethod methodStructure, @NotNull Parameter parameter) {
        this.parameter = parameter;
        this.methodStructure = methodStructure;
        this.rawAnnotated = new AnnotatedDescriptorDelegate(parameter::isAnnotationPresent, parameter::getAnnotation);
    }

    @Override
    public boolean ofType(@NotNull Class<?> type) {
        return type.isAssignableFrom(this.parameter.getType());
    }

    @Override
    @NotNull
    public Class<T> type() {
        return this.parameter.getType();
    }

    @Override
    public void referencesTo(@NotNull T ref) {
        this.ref = ref;
    }

    @NotNull
    public T value() {
        return this.ref;
    }

    @Override
    @NotNull
    public <T extends AnnotationSpec> T annotation(@NotNull Function<AnnotatedDescriptor, T> value) {
        return (T)((AnnotationSpec)value.apply(this.rawAnnotated));
    }

    @Override
    public boolean hasAnnotations(@NotNull Function<AnnotatedDescriptor, ? extends AnnotationSpec> handler) {
        return this.rawAnnotated.hasAnnotations(handler.apply(this.rawAnnotated).annotation());
    }
}

