/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.dynamics.foundation.reflection.structures;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.ametiste.dynamics.SurfaceFeature;
import org.ametiste.dynamics.SurfaceStructure;
import org.ametiste.dynamics.foundation.elements.AnnotationSpec;
import org.ametiste.dynamics.foundation.reflection.RuntimePattern;
import org.ametiste.dynamics.foundation.reflection.structures.Annotated;
import org.ametiste.dynamics.foundation.reflection.structures.AnnotatedDescriptor;
import org.ametiste.dynamics.foundation.reflection.structures.AnnotatedDescriptorDelegate;
import org.ametiste.dynamics.foundation.reflection.structures.ClassStructure;
import org.ametiste.dynamics.foundation.reflection.structures.MethodParameter;
import org.ametiste.dynamics.foundation.reflection.structures.ObjectInstance;
import org.jetbrains.annotations.NotNull;

@SurfaceStructure(superStructure={ClassStructure.class})
public class ClassMethod
implements Annotated {
    private final Method method;
    private final ClassStructure owner;
    private final AnnotatedDescriptorDelegate descriptor;

    public ClassMethod(@NotNull ClassStructure<?> owner, @NotNull Method method) {
        this.owner = owner;
        this.method = method;
        this.descriptor = new AnnotatedDescriptorDelegate(method::isAnnotationPresent, method::getAnnotation);
    }

    @SurfaceFeature
    @NotNull
    public String qualifiedName() {
        return this.owner.qualifiedName() + "#" + this.name();
    }

    @SurfaceFeature
    @NotNull
    public String name() {
        return this.method.getName();
    }

    @SurfaceFeature
    public void invoke(@NotNull ObjectInstance<?> instance, @NotNull UnaryOperator<RuntimePattern> matcher, @NotNull UnaryOperator<MethodParameter<Object>> mapper) {
        Object[] params = RuntimePattern.create(matcher).map(annotations -> Stream.of(this.method.getParameters()).filter(p -> annotations.stream().allMatch(p::isAnnotationPresent)).map(m -> new MethodParameter(this, (Parameter)m))).map(mapper).map(MethodParameter::value).toArray();
        try {
            this.method.invoke(instance.object, params);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @SurfaceFeature
    @NotNull
    public <T extends AnnotationSpec> T annotation(@NotNull Function<AnnotatedDescriptor, T> value) {
        return (T)((AnnotationSpec)value.apply(this.descriptor));
    }

    @Override
    @SurfaceFeature
    public boolean hasAnnotations(@NotNull Function<AnnotatedDescriptor, ? extends AnnotationSpec> handler) {
        return this.descriptor.hasAnnotations(handler.apply(this.descriptor).annotation());
    }
}

