/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.dynamics;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.ametiste.dynamics.BaseRightSurface;
import org.ametiste.dynamics.BaseSurface;
import org.ametiste.dynamics.RightSurface;

public interface Surface<E, S> {
    public boolean isSatisfiedBy(Predicate<S> var1);

    public void ifSatisfied(Predicate<S> var1, Consumer<S> var2);

    public <T> T map(Function<S, T> var1);

    public <T> void map(Function<S, T> var1, Consumer<T> var2);

    public void feature(Consumer<S> var1);

    public <T, R> R feature(Function<S, T> var1, Function<T, R> var2);

    public <T> Surface<S, T> depict(Function<S, T> var1);

    public <T> void depict(Function<S, T> var1, Consumer<Surface<S, T>> var2);

    public <T extends RightSurface<S>> void depictRight(Function<S, T> var1, Consumer<T> var2);

    public <T extends RightSurface<S>> void depictRight(Predicate<S> var1, Function<S, T> var2, Consumer<T> var3);

    public static <S> Surface<Void, S> ofPreSurface(Supplier<S> preSurface) {
        return new BaseSurface(preSurface);
    }

    public static <S> Surface<Void, S> ofPreSurface(S preSurface) {
        return new BaseSurface(() -> preSurface);
    }

    public static <S> RightSurface<S> rightSurface(S feature) {
        return new BaseRightSurface<Object>(() -> feature);
    }

    public static <S, T> Surface<S, T> asStructureOn(Function<S, T> structure, S feature) {
        return new BaseSurface<S, T>(feature, structure);
    }
}

