/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.protocol.containerapp;

import org.ametiste.laplatform.dsl.LambdaProtocol;
import org.ametiste.laplatform.dsl.ProtocolMeta;
import org.ametiste.routine.sdk.protocol.containerapp.ContainerAppProtocol;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@LambdaProtocol
@ProtocolMeta(group="core.infrastructure.protocol", shortName="spring-app-direct")
public class DirectSpringContainerAppConnection
implements ContainerAppProtocol {
    @Autowired
    private ApplicationContext applicationContext;

    public void systemOut(String operationOut) {
        System.out.println(this.applicationContext.getStartupDate() + ">" + operationOut);
    }

    @ProtocolMeta(shortName="env-prop")
    public <T> T envProperty(String propertyName, Class<T> type) {
        return (T)this.applicationContext.getEnvironment().getProperty(propertyName, type);
    }

    @ProtocolMeta(shortName="object")
    public <T> T object(Class<T> requiredType) {
        return (T)this.applicationContext.getBean(requiredType);
    }

    @ProtocolMeta(shortName="named-object")
    public <T> T namedObject(String name, Class<T> requiredType) {
        return (T)this.applicationContext.getBean(name, requiredType);
    }
}

