/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.dsl.domain.surface;

import java.util.List;
import java.util.stream.Stream;
import org.ametiste.dynamics.SurfaceFeature;
import org.ametiste.dynamics.SurfaceStructure;
import org.ametiste.dynamics.Surge;
import org.ametiste.dynamics.foundation.reflection.structures.ClassMethod;
import org.ametiste.dynamics.foundation.reflection.structures.ClassStructure;
import org.ametiste.routine.dsl.annotations.TaskOperation;
import org.ametiste.routine.dsl.domain.SchemeMappingAnnotation;
import org.ametiste.routine.dsl.domain.surface.RoutineOperationStructure;

@SurfaceStructure
public class RoutineTaskStructure {
    private final ClassStructure<?> klass;
    private final List<? extends Surge> fieldValues;
    private final List<? extends Surge> paramValues;

    public RoutineTaskStructure(ClassStructure<?> klass, List<? extends Surge> fieldValues, List<? extends Surge> paramValues) {
        this.klass = klass;
        this.fieldValues = fieldValues;
        this.paramValues = paramValues;
    }

    @SurfaceFeature
    public Stream<RoutineOperationStructure> operations() {
        return this.klass.mapMethods(method -> method.hasAnnotations(TaskOperation.class), method -> new RoutineOperationStructure(this.klass, (ClassMethod)method, this, this.fieldValues, this.paramValues), this::operationsOrder);
    }

    @SurfaceFeature
    public String controllerName() {
        return this.klass.qualifiedName();
    }

    @SurfaceFeature
    public String name() {
        return this.klass.annotation(SchemeMappingAnnotation::new).nameOrThrow(() -> new IllegalStateException("Can't resolve task scheme name mapping."));
    }

    private int operationsOrder(RoutineOperationStructure one, RoutineOperationStructure another) {
        if (one.order() > another.order()) {
            return 1;
        }
        if (one.order() < another.order()) {
            return -1;
        }
        throw new IllegalStateException("Operations order is undefined. Please define unique operations order explicitly.");
    }
}

