/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.dynamics.foundation.reflection.structures;

import java.util.List;
import org.ametiste.dynamics.Surface;
import org.ametiste.dynamics.SurfaceFeature;
import org.ametiste.dynamics.SurfaceStructure;
import org.ametiste.dynamics.Surge;
import org.ametiste.dynamics.foundation.reflection.structures.ClassMethod;
import org.ametiste.dynamics.foundation.reflection.structures.ObjectInstance;
import org.jetbrains.annotations.NotNull;

@SurfaceStructure(superStructure={ObjectInstance.class, ClassMethod.class})
public class ObjectInstanceMethod {
    private final ObjectInstance<?> object;
    private final ClassMethod method;

    public ObjectInstanceMethod(@NotNull ObjectInstance<?> object, @NotNull ClassMethod method) {
        this.object = object;
        this.method = method;
    }

    @SurfaceFeature
    public <C> void invoke(@NotNull List<? extends Surge> surge, @NotNull C context) {
        this.method.invoke(this.object, m -> m, parameter -> {
            surge.forEach(s -> s.explode(Surface.rightSurface(parameter), context));
            return parameter;
        });
    }
}

