/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.dynamics.foundation.reflection.structures;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.ametiste.dynamics.Surface;
import org.ametiste.dynamics.SurfaceFeature;
import org.ametiste.dynamics.SurfaceStructure;
import org.ametiste.dynamics.Surge;
import org.ametiste.dynamics.foundation.elements.AnnotationSpec;
import org.ametiste.dynamics.foundation.reflection.RuntimePattern;
import org.ametiste.dynamics.foundation.reflection.structures.Annotated;
import org.ametiste.dynamics.foundation.reflection.structures.AnnotatedDescriptor;
import org.ametiste.dynamics.foundation.reflection.structures.AnnotatedDescriptorDelegate;
import org.ametiste.dynamics.foundation.reflection.structures.ClassField;
import org.ametiste.dynamics.foundation.reflection.structures.ClassMethod;
import org.ametiste.dynamics.foundation.reflection.structures.ClassPool;
import org.ametiste.dynamics.foundation.reflection.structures.ObjectInstance;
import org.ametiste.dynamics.foundation.reflection.structures.ObjectInstanceField;
import org.jetbrains.annotations.NotNull;

@SurfaceStructure(superStructure={ClassPool.class})
public class ClassStructure<T>
implements Annotated {
    private final Class<T> klass;
    private final AnnotatedDescriptorDelegate descriptor;

    public ClassStructure(@NotNull Class<T> klass) {
        this.klass = klass;
        this.descriptor = new AnnotatedDescriptorDelegate(klass::isAnnotationPresent, klass::getAnnotation);
    }

    @SurfaceFeature
    public void fields(@NotNull UnaryOperator<RuntimePattern> matcher, @NotNull Consumer<ClassField> consumer) {
        RuntimePattern.create(matcher).let(annotations -> Stream.of(this.klass.getDeclaredFields()).filter(p -> annotations.stream().allMatch(p::isAnnotationPresent)).map(f -> new ClassField(this, (Field)f)).forEach(consumer));
    }

    @SurfaceFeature
    public void fields(@NotNull Consumer<ClassField> consumer) {
        Stream.of(this.klass.getDeclaredFields()).map(f -> new ClassField(this, (Field)f)).forEach(consumer);
    }

    @NotNull
    @SurfaceFeature
    public <T> Stream<T> mapMethods(@NotNull UnaryOperator<RuntimePattern> matcher, @NotNull Function<ClassMethod, T> mapper, @NotNull Comparator<T> order) {
        return this.mapMethods(matcher, mapper, s -> s.sorted(order));
    }

    @NotNull
    @SurfaceFeature
    public <T> Stream<T> mapMethods(@NotNull UnaryOperator<RuntimePattern> matcher, @NotNull Function<ClassMethod, T> mapper, @NotNull UnaryOperator<Stream<T>> enhance) {
        return RuntimePattern.create(matcher).map(annotations -> (Stream)enhance.apply(Stream.of(this.klass.getDeclaredMethods()).filter(m -> annotations.stream().allMatch(m::isAnnotationPresent)).map(m -> new ClassMethod(this, (Method)m)).map(mapper)));
    }

    @NotNull
    @SurfaceFeature
    public String qualifiedName() {
        return this.klass.getName();
    }

    @NotNull
    @SurfaceFeature
    public Class<T> type() {
        return this.klass;
    }

    @Override
    @NotNull
    public <T extends AnnotationSpec> T annotation(@NotNull Function<AnnotatedDescriptor, T> value) {
        return (T)((AnnotationSpec)value.apply(this.descriptor));
    }

    @Override
    public boolean hasAnnotations(@NotNull Function<AnnotatedDescriptor, ? extends AnnotationSpec> handler) {
        try {
            return this.descriptor.hasAnnotations(handler.apply(this.descriptor).annotation());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @SurfaceFeature
    public <C> void newInstance(@NotNull List<? extends Surge> surges, @NotNull C context, @NotNull Consumer<ObjectInstance<T>> consumer) {
        ObjectInstance<T> object;
        try {
            object = new ObjectInstance<T>(this.klass.newInstance(), this);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        object.fields((ObjectInstanceField<?> field) -> surges.forEach(s -> s.explode(Surface.rightSurface(field), context)));
        consumer.accept(object);
    }
}

