/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.dynamics.foundation.reflection.structures;

import java.lang.reflect.Field;
import java.util.function.Function;
import org.ametiste.dynamics.SurfaceFeature;
import org.ametiste.dynamics.SurfaceStructure;
import org.ametiste.dynamics.foundation.elements.AnnotationSpec;
import org.ametiste.dynamics.foundation.reflection.structures.Annotated;
import org.ametiste.dynamics.foundation.reflection.structures.AnnotatedDescriptor;
import org.ametiste.dynamics.foundation.reflection.structures.AnnotatedDescriptorDelegate;
import org.ametiste.dynamics.foundation.reflection.structures.ClassStructure;
import org.jetbrains.annotations.NotNull;

@SurfaceStructure(superStructure={ClassStructure.class})
public class ClassField
implements Annotated {
    final Field field;
    private final AnnotatedDescriptorDelegate descriptor;
    private final ClassStructure<?> classStructure;

    public ClassField(@NotNull ClassStructure<?> classStructure, @NotNull Field field) {
        this.field = field;
        this.classStructure = classStructure;
        this.descriptor = new AnnotatedDescriptorDelegate(field::isAnnotationPresent, field::getAnnotation);
    }

    @SurfaceFeature
    @NotNull
    public Class<?> type() {
        return this.field.getType();
    }

    @Override
    @NotNull
    @SurfaceFeature
    public <T extends AnnotationSpec> T annotation(@NotNull Function<AnnotatedDescriptor, T> value) {
        return (T)((AnnotationSpec)value.apply(this.descriptor));
    }

    @Override
    @SurfaceFeature
    public boolean hasAnnotations(@NotNull Function<AnnotatedDescriptor, ? extends AnnotationSpec> handler) {
        return this.descriptor.hasAnnotations(handler.apply(this.descriptor).annotation());
    }
}

