/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.dynamics.foundation.reflection.structures;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.ametiste.dynamics.foundation.reflection.structures.AnnotatedDescriptor;
import org.jetbrains.annotations.NotNull;

class AnnotatedDescriptorDelegate
implements AnnotatedDescriptor {
    private final Predicate<Stream<Class<? extends Annotation>>> hasAnnotations;
    private final BiFunction<Class<? extends Annotation>, Function, Optional> annotationValue;

    public AnnotatedDescriptorDelegate(@NotNull Predicate<Stream<Class<? extends Annotation>>> hasAnnotations, @NotNull BiFunction<Class<? extends Annotation>, Function, Optional> annotationValue) {
        this.hasAnnotations = hasAnnotations;
        this.annotationValue = annotationValue;
    }

    public AnnotatedDescriptorDelegate(@NotNull Predicate<Class<? extends Annotation>> isAnnotationPresent, @NotNull Function<Class<? extends Annotation>, Annotation> extractAnnotation) {
        this((Stream<Class<? extends Annotation>> annotations) -> annotations.allMatch(isAnnotationPresent), (Class<? extends Annotation> annotation, Function transform) -> Optional.ofNullable(extractAnnotation.apply((Class<? extends Annotation>)annotation)).map(transform));
    }

    @Override
    public boolean hasAnnotations(Class<? extends Annotation> ... annotations) {
        return this.hasAnnotations.test(Stream.of(annotations));
    }

    @Override
    @NotNull
    public <T, A extends Annotation> Optional<T> annotationValue(@NotNull Function<A, T> value, @NotNull Class<A> annotation) {
        return this.annotationValue.apply(annotation, value);
    }
}

