/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.dynamics;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.ametiste.dynamics.RightSurface;
import org.ametiste.dynamics.Surface;
import org.ametiste.lang.Elective;

public class BaseSurface<E, S>
implements Surface<E, S> {
    protected final E enclosingSurface;
    protected final S subSurface;

    public BaseSurface(E enclosingSurface, Function<E, S> subSurface) {
        this.enclosingSurface = enclosingSurface;
        this.subSurface = subSurface.apply(enclosingSurface);
    }

    public BaseSurface(Supplier<S> subSurface) {
        this(null, e -> subSurface.get());
    }

    public BaseSurface(E enclosingSurface) {
        this(enclosingSurface, null);
    }

    @Override
    public final <T> T map(Function<S, T> transform) {
        return transform.apply(this.subSurface);
    }

    @Override
    public final <T> void map(Function<S, T> structure, Consumer<T> features) {
        features.accept(this.map(structure));
    }

    @Override
    public final <T, R> R feature(Function<S, T> structure, Function<T, R> features) {
        return features.apply(structure.apply(this.subSurface));
    }

    @Override
    public final boolean isSatisfiedBy(Predicate<S> predicate) {
        return predicate.test(this.subSurface);
    }

    @Override
    public final void ifSatisfied(Predicate<S> predicate, Consumer<S> let) {
        Elective.let(predicate, this.subSurface, let);
    }

    @Override
    public final void feature(Consumer<S> feature) {
        feature.accept(this.subSurface);
    }

    @Override
    public final <T> Surface<S, T> depict(Function<S, T> structure) {
        return Surface.asStructureOn(structure, this.subSurface);
    }

    @Override
    public final <T> void depict(Function<S, T> structure, Consumer<Surface<S, T>> depicted) {
        depicted.accept(this.depict(structure));
    }

    @Override
    public final <T extends RightSurface<S>> void depictRight(Predicate<S> predicate, Function<S, T> structure, Consumer<T> depicted) {
        if (this.isSatisfiedBy(predicate)) {
            this.depictRight(structure, depicted);
        }
    }

    @Override
    public final <T extends RightSurface<S>> void depictRight(Function<S, T> structure, Consumer<T> depicted) {
        depicted.accept(structure.apply(this.subSurface));
    }
}

