/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.stat.interfaces.metrics;

import org.ametiste.metrics.MetricsService;
import org.ametiste.routine.infrastructure.laplatform.LaPlatformStatsService;
import org.ametiste.routine.stat.application.MetricsSource;
import org.ametiste.routine.stat.interfaces.metrics.LaPlatformMetrics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"org.ametiste.routine.metrics.source.platform.protocols.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={LaPlatformStatsService.class})
public class LaPlatformStatsMetricsSource
implements MetricsSource {
    @Autowired
    private LaPlatformStatsService laPlatformStatsService;

    @Override
    public void provideMetric(MetricsService metricsService) {
        this.laPlatformStatsService.loadProtocolStats(s -> metricsService.gauge(LaPlatformMetrics.protocolsCreatedCountMetric(s.name()), (int)s.createdForPeriod()));
    }
}

