/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.meta.scheme;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.ametiste.lang.object.trace.MethodCallEvent;
import org.ametiste.lang.object.trace.MethodCallListener;
import org.ametiste.routine.dsl.annotations.OperationParameter;
import org.ametiste.routine.meta.scheme.ParamValueConverter;
import org.ametiste.routine.meta.scheme.TaskSchemeCall;
import org.ametiste.routine.meta.scheme.TaskSchemeTrace;

class TaskSchemeCallListener
implements MethodCallListener {
    private final String schemeName;
    private final ParamValueConverter converter;
    private final List<TaskSchemeCall> calls = new ArrayList<TaskSchemeCall>(4);

    public TaskSchemeCallListener(String schemeName, ParamValueConverter converter) {
        this.schemeName = schemeName;
        this.converter = converter;
    }

    public void methodCalled(MethodCallEvent methodCallEvent) {
        int p = 0;
        HashMap<String, String> callParams = new HashMap<String, String>();
        for (Annotation[] parameterType : methodCallEvent.method().getParameterAnnotations()) {
            if (!(parameterType[0] instanceof OperationParameter)) {
                throw new IllegalStateException("");
            }
            String name = ((OperationParameter)parameterType[0]).value();
            String value = this.converter.convert(methodCallEvent.args()[p]);
            callParams.put(name, value);
            ++p;
        }
        this.calls.add(TaskSchemeCall.of(callParams));
    }

    public void provideTracedCallScheme(Consumer<TaskSchemeTrace> schemeCallConsumer) {
        schemeCallConsumer.accept(new TaskSchemeTrace(this.schemeName, this.calls));
    }
}

