/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.dsl.domain.surface;

import java.util.List;
import org.ametiste.dynamics.SurfaceFeature;
import org.ametiste.dynamics.SurfaceStructure;
import org.ametiste.dynamics.Surge;
import org.ametiste.dynamics.foundation.reflection.structures.ClassMethod;
import org.ametiste.dynamics.foundation.reflection.structures.ClassStructure;
import org.ametiste.laplatform.protocol.ProtocolGateway;
import org.ametiste.routine.dsl.domain.SchemeMappingAnnotation;
import org.ametiste.routine.dsl.domain.TaskOperationAnnotation;
import org.ametiste.routine.dsl.domain.surface.RoutineTaskStructure;

@SurfaceStructure
public class RoutineOperationStructure {
    private final ClassStructure<?> controller;
    private final ClassMethod action;
    private final RoutineTaskStructure task;
    private final List<? extends Surge> fields;
    private final List<? extends Surge> params;

    public RoutineOperationStructure(ClassStructure<?> controller, ClassMethod action, RoutineTaskStructure task, List<? extends Surge> fields, List<? extends Surge> params) {
        this.controller = controller;
        this.action = action;
        this.task = task;
        this.fields = fields;
        this.params = params;
    }

    @SurfaceFeature
    public String actionName() {
        return this.action.qualifiedName();
    }

    @SurfaceFeature
    public String name() {
        return this.task.name() + "-" + this.action.annotation(SchemeMappingAnnotation::new).nameOrDefault(() -> this.action.name());
    }

    @SurfaceFeature
    public void invoke(ProtocolGateway gateway) {
        this.controller.newInstance(this.fields, gateway, controllerInstance -> controllerInstance.method(this.action, instanceMethod -> instanceMethod.invoke(this.params, gateway)));
    }

    @SurfaceFeature
    public int order() {
        return this.action.annotation(TaskOperationAnnotation::new).orderOrThrow(() -> new IllegalStateException("Can't resolve operation name."));
    }
}

