/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.dsl.application;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.ametiste.routine.domain.scheme.TaskBuilder;
import org.ametiste.routine.domain.scheme.TaskScheme;
import org.ametiste.routine.domain.scheme.TaskSchemeException;
import org.ametiste.routine.dsl.application.DynamicOperationScheme;
import org.ametiste.routine.dsl.application.DynamicParamsProtocol;
import org.ametiste.routine.dsl.infrastructure.protocol.DirectDynamicParamsProtocol;
import org.ametiste.routine.sdk.protocol.operation.ParamsProtocol;

public class DynamicTaskScheme
implements TaskScheme<DynamicParamsProtocol> {
    private final String name;
    private final List<DynamicOperationScheme> operations;

    public DynamicTaskScheme(String name, List<DynamicOperationScheme> operations) {
        this.name = name;
        this.operations = new ArrayList<DynamicOperationScheme>(operations);
    }

    public String schemeName() {
        return this.name;
    }

    public void setupTask(TaskBuilder<DynamicParamsProtocol> taskBuilder, Consumer<DynamicParamsProtocol> paramsInstaller, String creatorIdenifier) throws TaskSchemeException {
        DirectDynamicParamsProtocol dynamicParamsProtocol = new DirectDynamicParamsProtocol();
        paramsInstaller.accept(dynamicParamsProtocol);
        this.operations.forEach(op -> taskBuilder.addOperation(op.schemeName(), (ParamsProtocol)dynamicParamsProtocol));
    }
}

