/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.lang;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.ametiste.lang.Elective;

public class Triple<F, S, T> {
    public final F first;
    public final S second;
    public final T third;

    public Triple(F first, S second, T third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public final <R> R map(Function<Triple<F, S, T>, R> transform) {
        return transform.apply(this);
    }

    public final <R> R mapFirstSecond(BiFunction<F, S, R> transform) {
        return transform.apply(this.first, this.second);
    }

    public final <R> R mapFirstThird(BiFunction<F, T, R> transform) {
        return transform.apply(this.first, this.third);
    }

    public final <R> R mapSecondThird(BiFunction<S, T, R> transform) {
        return transform.apply(this.second, this.third);
    }

    public final <R> R mapSecondFirst(BiFunction<S, F, R> transform) {
        return transform.apply(this.second, this.first);
    }

    public final <R> R mapThirdFirst(BiFunction<T, F, R> transform) {
        return transform.apply(this.third, this.first);
    }

    public final <R> R mapThirdSecond(BiFunction<T, S, R> transform) {
        return transform.apply(this.third, this.second);
    }

    public F first() {
        return this.first;
    }

    public S second() {
        return this.second;
    }

    public T third() {
        return this.third;
    }

    public static final <F, S, T> Elective<Triple<F, S, T>> let(F first, S second, T third) {
        return c -> c.accept(Triple.of(first, second, third));
    }

    public static final <F, S, T> Triple<F, S, T> of(F first, S second, T third) {
        return new Triple<F, S, T>(first, second, third);
    }

    static class Dog {
        private final String name;
        private final Integer size;

        public Dog(String name, Integer size) {
            this.name = name;
            this.size = size;
        }
    }

    static class Cat {
        private final String name;
        private final Integer size;

        public Cat(String name, Integer size) {
            this.name = name;
            this.size = size;
        }
    }
}

