/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.lang;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.ametiste.lang.Elective;
import org.ametiste.lang.Transformable;

public class Pair<F, S>
implements Elective<Pair<F, S>>,
Transformable<Pair<F, S>> {
    public final F first;
    public final S second;

    public Pair(F first, S second) {
        this.first = first;
        this.second = second;
    }

    public static final <F, S> Pair<F, S> of(F first, S second) {
        return new Pair<F, S>(first, second);
    }

    public static <T, U> List<Pair<T, U>> of(List<T> firsts, List<U> seconds) {
        if (firsts.size() != seconds.size()) {
            throw new IllegalArgumentException("Lists to pair must have an equal size!");
        }
        ArrayList<Pair<T, U>> pairs = new ArrayList<Pair<T, U>>();
        for (int i = 0; i < firsts.size(); ++i) {
            pairs.add(Pair.of(firsts.get(i), seconds.get(i)));
        }
        return pairs;
    }

    public F first() {
        return this.first;
    }

    public S second() {
        return this.second;
    }

    public void asMapEntryFirstKey(Map<F, S> map) {
        map.put(this.first, this.second);
    }

    public void asMapEntrySecondKey(Map<S, F> map) {
        map.put(this.second, this.first);
    }

    @Override
    public void let(Consumer<Pair<F, S>> block) {
        block.accept(this);
    }

    @Override
    public <R> R map(Function<Pair<F, S>, R> transformation) {
        return transformation.apply(this);
    }
}

