/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametiste.lang.Pair;

public class AmeCollections {
    public static <T> List<T> mergeUnique(List<T> first, List<T> second) {
        List<T> merged = AmeCollections.merge(first, second);
        ArrayList unique = new ArrayList(merged.size());
        merged.stream().filter(a -> !unique.contains(a)).forEach(unique::add);
        return AmeCollections.readOnlyList(unique);
    }

    public static <T> List<T> merge(List<T> first, List<T> second) {
        ArrayList<T> merged = new ArrayList<T>(first);
        merged.addAll(second);
        return AmeCollections.readOnlyList(merged);
    }

    public static <T> List<T> readOnlyList(List<T> other) {
        return Collections.unmodifiableList(new ArrayList<T>(other));
    }

    public static <T> List<T> readOnlyList(T ... elements) {
        return Collections.unmodifiableList(Arrays.asList(elements));
    }

    public static <K, V> Map<K, V> readOnlyMap(Consumer<Map<K, V>> builder) {
        HashMap source = new HashMap();
        builder.accept(source);
        return AmeCollections.readOnlyMap(source);
    }

    public static <K, V> Map<K, V> readOnlyMap(Map<K, V> other) {
        return Collections.unmodifiableMap(new HashMap<K, V>(other));
    }

    public static <K, V> Map<K, V> readOnlyMap(Stream<Pair<K, V>> entries) {
        return entries.collect(Collectors.toMap(p -> p.first, p -> p.second));
    }

    public static <K, V> Map<K, V> readOnlyMap(List<Pair<K, V>> entries) {
        return AmeCollections.readOnlyMap(entries.stream());
    }

    public static <K, V> Map<K, V> readOnlyMap(Pair<K, V> ... entries) {
        return AmeCollections.readOnlyMap(Stream.of(entries));
    }

    public static <K, V> Pair<K, V> entry(K key, V value) {
        return Pair.of(key, value);
    }

    public static <V> Map<Class<?>, V> readOnlyMapOfClassObjects(V ... entries) {
        return AmeCollections.readOnlyMap(Stream.of(entries).map(AmeCollections::classAsKey));
    }

    public static <V> Pair<Class<?>, V> classAsKey(V value) {
        return Pair.of(value.getClass(), value);
    }
}

