/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.dynamics.foundation.reflection.structures;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.ametiste.dynamics.SurfaceFeature;
import org.ametiste.dynamics.SurfaceStructure;
import org.ametiste.dynamics.foundation.elements.AnnotationSpec;
import org.ametiste.dynamics.foundation.reflection.RuntimePattern;
import org.ametiste.dynamics.foundation.reflection.structures.Annotated;
import org.ametiste.dynamics.foundation.reflection.structures.AnnotatedDescriptor;
import org.ametiste.dynamics.foundation.reflection.structures.ClassField;
import org.ametiste.dynamics.foundation.reflection.structures.ClassMethod;
import org.ametiste.dynamics.foundation.reflection.structures.ClassStructure;
import org.ametiste.dynamics.foundation.reflection.structures.ObjectInstanceField;
import org.ametiste.dynamics.foundation.reflection.structures.ObjectInstanceMethod;
import org.jetbrains.annotations.NotNull;

@SurfaceStructure(superStructure={ClassStructure.class})
public class ObjectInstance<T>
implements Annotated {
    final T object;
    private final ClassStructure<T> classStructure;

    public ObjectInstance(@NotNull T object, @NotNull ClassStructure<T> classStructure) {
        this.object = object;
        this.classStructure = classStructure;
    }

    @NotNull
    @SurfaceFeature
    public Class<T> type() {
        return this.classStructure.type();
    }

    @SurfaceFeature
    public void fields(@NotNull UnaryOperator<RuntimePattern> matcher, @NotNull Consumer<ObjectInstanceField<?>> consumer) {
        this.classStructure.fields(matcher, (ClassField classField) -> consumer.accept(new ObjectInstanceField((ClassField)classField, this)));
    }

    @SurfaceFeature
    public void fields(@NotNull Consumer<ObjectInstanceField<?>> consumer) {
        this.classStructure.fields((ClassField classField) -> consumer.accept(new ObjectInstanceField((ClassField)classField, this)));
    }

    @SurfaceFeature
    public void method(@NotNull ClassMethod method, @NotNull Consumer<ObjectInstanceMethod> consumer) {
        consumer.accept(new ObjectInstanceMethod(this, method));
    }

    @Override
    @NotNull
    public <T extends AnnotationSpec> T annotation(@NotNull Function<AnnotatedDescriptor, T> value) {
        return this.classStructure.annotation(value);
    }

    @Override
    public boolean hasAnnotations(@NotNull Function<AnnotatedDescriptor, ? extends AnnotationSpec> handler) {
        return this.classStructure.hasAnnotations(handler);
    }
}

