/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.stat.persistency;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.ametiste.routine.stat.CoreStatRepository;

public class InMemoryCoreStatRepository
implements CoreStatRepository {
    public Map<String, AtomicLong> counters = new HashMap<String, AtomicLong>();

    public void incrementStat(String statName) {
        this.incrementStat(statName, 1L);
    }

    public void incrementStat(String statName, long delta) {
        this.getCounter(statName).addAndGet(delta);
    }

    public Long loadStat(String statName) {
        return this.getCounter(statName).get();
    }

    public Map<String, Long> loadStat() {
        return this.counters.entrySet().stream().collect(Collectors.toMap(k -> (String)k.getKey(), v -> ((AtomicLong)v.getValue()).get()));
    }

    private AtomicLong getCounter(String statName) {
        return this.counters.computeIfAbsent(statName, k -> new AtomicLong());
    }
}

