/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.stat.application;

import java.util.List;
import org.ametiste.metrics.MetricsService;
import org.ametiste.routine.stat.application.MetricsSource;
import org.ametiste.routine.stat.application.MetricsSourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicMetricsSourceService
implements MetricsSourceService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MetricsService metricsService;
    private final List<MetricsSource> metricsSources;

    public BasicMetricsSourceService(MetricsService metricsService, List<MetricsSource> metricsSources) {
        this.metricsService = metricsService;
        this.metricsSources = metricsSources;
    }

    @Override
    public void provideMetrics() {
        this.metricsSources.forEach(this::provideSafe);
    }

    private void provideSafe(MetricsSource metricsSource) {
        block2: {
            try {
                metricsSource.provideMetric(this.metricsService);
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error("Error during metrics provider execution: " + metricsSource.getClass().getName(), e);
            }
        }
    }
}

