/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.persistency.jpa.data;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.ametiste.routine.infrastructure.persistency.jpa.data.OperationNoticeData;
import org.ametiste.routine.infrastructure.persistency.jpa.data.OperationPropertyData;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskData;
import org.springframework.data.domain.Persistable;

@Entity
@Table(name="ame_routine_task_operation", indexes={@Index(name="op_state_idx", columnList="state", unique=false), @Index(name="op_task_idx", columnList="task_id", unique=false)})
public class OperationData
implements Persistable<UUID> {
    private UUID id;
    private String label;
    private String state;
    private TaskData task;
    private List<OperationPropertyData> properties = new ArrayList<OperationPropertyData>();
    private List<OperationNoticeData> notices = new ArrayList<OperationNoticeData>();

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="task_id", foreignKey=@ForeignKey(name="fk_task_op_task_id"))
    public TaskData getTask() {
        return this.task;
    }

    @ElementCollection
    @CollectionTable(name="ame_routine_task_operation_property", joinColumns={@JoinColumn(name="operation_id")}, indexes={@Index(name="op_prop_op_id_idx", columnList="operation_id", unique=false)})
    @org.hibernate.annotations.ForeignKey(name="fk_op_prop_op_id")
    public List<OperationPropertyData> getProperties() {
        return this.properties;
    }

    @ElementCollection
    @CollectionTable(name="ame_routine_task_operation_notice", joinColumns={@JoinColumn(name="operation_id")}, foreignKey=@ForeignKey(name="fk_op_notice_op_id"), indexes={@Index(name="op_notice_op_id_idx", columnList="operation_id", unique=false)})
    @org.hibernate.annotations.ForeignKey(name="fk_op_notice_op_id")
    public List<OperationNoticeData> getNotices() {
        return this.notices;
    }

    @Id
    public UUID getId() {
        return this.id;
    }

    @Transient
    public boolean isNew() {
        return this.state.equals("NEW");
    }

    public void setNotices(List<OperationNoticeData> notices) {
        this.notices = notices;
    }

    public void addNoticeData(OperationNoticeData operationNoticeData) {
        this.notices.add(operationNoticeData);
    }

    public void addPropertyData(OperationPropertyData operationPropertyData) {
        this.properties.add(operationPropertyData);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTask(TaskData task) {
        this.task = task;
    }

    public void setProperties(List<OperationPropertyData> properties) {
        this.properties = properties;
    }
}

