/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.persistency.jpa;

import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.ametiste.metrics.annotations.Timeable;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.domain.task.TaskRepository;
import org.ametiste.routine.domain.task.reflect.TaskReflection;
import org.ametiste.routine.infrastructure.persistency.jpa.JPATaskDataRepository;
import org.ametiste.routine.infrastructure.persistency.jpa.JPATaskFilter;
import org.ametiste.routine.infrastructure.persistency.jpa.JPATaskReflection;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskData;
import org.ametiste.routine.sdk.domain.TaskFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class SpringDataTaskRepository
implements TaskRepository {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JPATaskDataRepository jpaTaskDataRepository;

    public SpringDataTaskRepository(JPATaskDataRepository jpaTaskDataRepository) {
        this.jpaTaskDataRepository = jpaTaskDataRepository;
    }

    @Transactional
    @Timeable(name="core.infrastructure.persistency.task-repository.find-by-id.timing")
    public Task findTask(UUID taskId) {
        return this.reflectDataAsTask((TaskData)this.jpaTaskDataRepository.findOne(taskId));
    }

    @Transactional
    @Timeable(name="core.infrastructure.persistency.task-repository.find-by-state.timing")
    public List<Task> findTasksByState(Task.State state, int limit) {
        return this.jpaTaskDataRepository.findByState(state).stream().map(this::reflectDataAsTask).collect(Collectors.toList());
    }

    @Transactional
    @Timeable(name="core.infrastructure.persistency.task-repository.find-by-multiple-state.timing")
    public List<Task> findTasksByState(List<Task.State> state, int limit) {
        return this.jpaTaskDataRepository.findByStateIn(state.stream().map(Enum::name).collect(Collectors.toList()), (Pageable)new PageRequest(0, limit)).getContent().stream().map(this::reflectDataAsTask).collect(Collectors.toList());
    }

    @Transactional
    @Timeable(name="core.infrastructure.persistency.task-repository.save.timing")
    public void saveTask(Task task) {
        JPATaskReflection jpaTaskReflection = new JPATaskReflection();
        task.reflectAs((TaskReflection)jpaTaskReflection);
        this.jpaTaskDataRepository.save(jpaTaskReflection.reflectedTaskData());
    }

    @Transactional
    @Timeable(name="core.infrastructure.persistency.task-repository.find-by-op-id.timing")
    public Task findTaskByOperationId(UUID operationId) {
        return this.reflectDataAsTask(this.jpaTaskDataRepository.findByOperationsId(operationId));
    }

    @Transactional
    @Timeable(name="core.infrastructure.persistency.task-repository.find-with-filter.timing")
    public List<Task> findTasks(Consumer<TaskFilter> filterBuilder) {
        return this.jpaTaskDataRepository.findAll(JPATaskFilter.buildBy(filterBuilder)).stream().map(this::reflectDataAsTask).collect(Collectors.toList());
    }

    @Transactional
    @Timeable(name="core.infrastructure.persistency.task-repository.count-with-filter.timing")
    public long countTasks(Consumer<TaskFilter> filterBuilder) {
        return this.jpaTaskDataRepository.count(JPATaskFilter.buildBy(filterBuilder));
    }

    @Transactional
    @Timeable(name="core.infrastructure.persistency.task-repository.delete.timing")
    public void deleteTasks(List<Task.State> states, Instant after) {
        this.jpaTaskDataRepository.deleteByStateAndCompletionDate(states.stream().map(Enum::name).collect(Collectors.toList()), Date.from(after));
    }

    private Task reflectDataAsTask(TaskData taskData) {
        return new Task((TaskReflection)new JPATaskReflection(taskData));
    }
}

