/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.persistency.jpa;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.infrastructure.persistency.jpa.TaskDataSpecifications;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskData;
import org.ametiste.routine.sdk.domain.TaskFilter;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;

public class JPATaskFilter
implements TaskFilter {
    private List<Specification<TaskData>> specifications = new ArrayList<Specification<TaskData>>();

    public static final Specification<TaskData> buildBy(Consumer<TaskFilter> builder) {
        JPATaskFilter jpaTaskFilter = new JPATaskFilter();
        builder.accept(jpaTaskFilter);
        return jpaTaskFilter.buildSpecification().orElseThrow(() -> new IllegalArgumentException("Atleast one filter predicate must be used."));
    }

    public void stateIn(List<String> state) {
        this.specifications.add(TaskDataSpecifications.hasState(state.stream().map(Task.State::valueOf).collect(Collectors.toList())));
    }

    public void creationTimeAfter(Instant time) {
        this.specifications.add(TaskDataSpecifications.afterCreationTime(time));
    }

    public void execStartTimeAfter(Instant time) {
        this.specifications.add(TaskDataSpecifications.afterExecStartTime(time));
    }

    public void completionTimeAfter(Instant time) {
        this.specifications.add(TaskDataSpecifications.afterCompletionTime(time));
    }

    public Optional<Specification<TaskData>> buildSpecification() {
        Iterator<Specification<TaskData>> iterator = this.specifications.iterator();
        if (iterator.hasNext()) {
            Specifications specification = Specifications.where(iterator.next());
            while (iterator.hasNext()) {
                specification = specification.and(iterator.next());
            }
            return Optional.of(specification);
        }
        return Optional.empty();
    }
}

